/****************************************************************************
 **                                                                        **
 **  "(Indendent) Love Bong - win32 version" 64K intro - Aron, 1999.02.01. **
 **                                                                        **
 ****************************************************************************/

// - szabvany headerfile-ok -----------------------------------------------
#include <math.h>
#include <windows.h>
#include <mmsystem.h>
#include "c:\Program Files\DX5SDK\sdk\inc\ddraw.h"
#include "\librarie.s\midas.112\include\midasdll.h"

// - sajat headerfile-ok --------------------------------------------------
#include "resource.h"
#include "Main.hpp"
#include "Audio.hpp"
#include "Video.hpp"
#include "Compile.h"
#include "Defs.h"
#include "Bitmap.hpp"
#include "MiniPicturesData.h"
#include "Texture.hpp"
#include "Tracer.hpp"

// - implementacio --------------------------------------------------------
HINSTANCE hInstance;
HWND hMainWindow;
BOOL bActive;
BOOL bHideCursor;

extern LPDIRECTDRAWSURFACE lpDDSBack;
BOOL bDDrawInitialized= FALSE;

extern MIDASmodulePlayHandle hPlaying;
extern DWORD dwSyncValue;

#include "DemoProcess.hpp"

// - timer rutin ------------------------------------------------------------
void PollTimer(void)
{
	dwTimer= (timeGetTime() - dwTimeStart)/(1000/50);
}

// - kepkonverter fuggvenyek ------------------------------------------------
DDSURFACEDESC ddsdBack;
byte *surfaceptr;

void UpdateScreen32bit(byte *framebufferptr)
{
	// 32bit-es framebuffer attoltese a 32bit-es surface-re:
	lpDDSBack->Lock(NULL,&ddsdBack,0,NULL);
	surfaceptr= (byte *)ddsdBack.lpSurface + 10*ddsdBack.lPitch;

	__asm
	{
					mov edi,[surfaceptr]
					mov esi,[framebufferptr]
					mov ecx,320*180
					rep movsd
	}
	
	lpDDSBack->Unlock(NULL);
	FlipSurfaces();
}

void UpdateScreen24bit(byte *framebufferptr)
{
	// 32bit-es framebuffer konvertalasa a 24bit-es surface-re:
	lpDDSBack->Lock(NULL,&ddsdBack,0,NULL);
	surfaceptr= (byte *)ddsdBack.lpSurface + 10*ddsdBack.lPitch;

	__asm
	{
					mov edi,[surfaceptr]
					mov esi,[framebufferptr]
					mov ecx,320*180
		NxtPix:		movsd
					dec edi				// egy byte visszalepes a 24bit miatt 
					dec ecx
					jnz NxtPix
	}
	
	lpDDSBack->Unlock(NULL);
	FlipSurfaces();
}

void UpdateScreen16bit(byte *framebufferptr)
{
	// 32bit-es framebuffer konvertalasa a 16bit-es surface-re:
	lpDDSBack->Lock(NULL,&ddsdBack,0,NULL);
	surfaceptr= (byte *)ddsdBack.lpSurface + 10*ddsdBack.lPitch;

	__asm
	{
					mov edi,[surfaceptr]
					mov esi,[framebufferptr]
					mov ecx,320*180
		Convrt:		mov al,byte ptr [esi + 2]
					mov bl,byte ptr [esi + 1]
					and al,11111000b
					and bx,11111100b
					shl ax,8			// AX:= R 
					shl bx,3
					mov dl,byte ptr [esi]
					or ax,bx			// AX:= RG 
					shr dl,3
					add esi,4			// kovetkezo triplet-re mutat 
					or al,dl			// AX:= RGB 
					dec ecx
					stosw				// 16bites pixel ki
					jnz Convrt
	}

	lpDDSBack->Unlock(NULL);
	FlipSurfaces();
}

// - setup dialogus ablak ---------------------------------------------------
extern dword dwRTXResolution,dwRTYResolution,dwRTXAdder,dwRTYAdder;
extern float fRTXResolution,fRTYResolution,fRTHalfXResolution,fRTHalfYResolution;
DWORD dwBitDepthSelected;

BOOL CALLBACK SetupDlgProc(HWND hDlg,UINT msg,WPARAM wParam,LPARAM lPraram)
{
	switch(msg)
	{
		case WM_INITDIALOG:	
		{
			// videomodok enumeralasa es valaszthato modok engedelyezese/default engedelyezese:
			DWORD i= DetectVideoModes();

			if(i & 4) 
			{
				EnableWindow(GetDlgItem(hDlg,IDC_RADIOFULLSCREEN32),TRUE);
				SendDlgItemMessage(hDlg,IDC_RADIOFULLSCREEN32,BM_SETCHECK,TRUE,0);
			}
			if(i & 2) 
			{
				EnableWindow(GetDlgItem(hDlg,IDC_RADIOFULLSCREEN24),TRUE);
				if(i < 4) SendDlgItemMessage(hDlg,IDC_RADIOFULLSCREEN24,BM_SETCHECK,TRUE,0);
			}
			if(i & 1) 
			{
				EnableWindow(GetDlgItem(hDlg,IDC_RADIOFULLSCREEN16),TRUE);
				if(i == 1) SendDlgItemMessage(hDlg,IDC_RADIOFULLSCREEN16,BM_SETCHECK,TRUE,0);
			}
			
			// default felbontas beallitasa:
			SendDlgItemMessage(hDlg,IDC_RADIOLORES,BM_SETCHECK,TRUE,0);
			
			return TRUE;
		}

		case WM_COMMAND:
		{
			switch(wParam) 
			{
				case ID_STARTINTRO:
				{
					// raytracer parameterek beallitasa a valasztasnak megfeleloen:
					if(SendDlgItemMessage(hDlg,IDC_RADIOLORES,BM_GETCHECK,0,0) == BST_CHECKED)
					{
						// alacsony felbontas:
						dwRTXResolution= 81; 
						dwRTYResolution= 46;
						dwRTXAdder= 4*4;
						dwRTYAdder= 4*(3*320 - 4);

						fRTXResolution= 80;
						fRTYResolution= 45;

						InterpolateFrameBuffer= InterpolateFrameBuffer4;
					}
					else if(SendDlgItemMessage(hDlg,IDC_RADIOMEDIUMRES,BM_GETCHECK,0,0) == BST_CHECKED)
					{
						// kozepes felbontas:
						dwRTXResolution= 161;
						dwRTYResolution= 91;
						dwRTXAdder= 2*4;
						dwRTYAdder= 4*(320 - 2);

						fRTXResolution= 160;
						fRTYResolution= 90;

						InterpolateFrameBuffer= InterpolateFrameBuffer2;
					}
					else
					{
						// nagy felbontas:
						dwRTXResolution= 320;
						dwRTYResolution= 180;
						dwRTXAdder= 1*4;
						dwRTYAdder= 0;

						fRTXResolution= 320;
						fRTYResolution= 180;

						InterpolateFrameBuffer= InterpolateFrameBuffer1;
					}

					fRTHalfXResolution= fRTXResolution / 2.0f;
					fRTHalfYResolution= fRTYResolution / 2.0f;

					// kepfrissito fuggveny bekotese a valasztott videomodnak megfeleloen:
					if(SendDlgItemMessage(hDlg,IDC_RADIOFULLSCREEN32,BM_GETCHECK,0,0) == BST_CHECKED)
					{
						dwBitDepthSelected= 32;
						UpdateScreen= UpdateScreen32bit;
					}
					else if(SendDlgItemMessage(hDlg,IDC_RADIOFULLSCREEN24,BM_GETCHECK,0,0) == BST_CHECKED)
					{
						dwBitDepthSelected= 24;
						UpdateScreen= UpdateScreen24bit;
					}
					else
					{
						dwBitDepthSelected= 16;
						UpdateScreen= UpdateScreen16bit;
					}
					ddsdBack.dwSize= sizeof(DDSURFACEDESC);
				
					EndDialog(hDlg,0);
					break;
				}

				case IDC_AUDIOSETUP:
				{
					SetupAudioSystem(hDlg);
					break;
				}

				case IDC_VIEWINFO:
				{
					MessageBox(hDlg,"\
\"(Independent) Love Bong\" (win32 version)\n\n\
(placed first at The Contest 99 in the 64K intro competition)\n\n\
Some modifications were made. To spare the quite long precalculation \
time, data was precalculated and compressed to datafiles, so the size \
is not 64K anymore. If you don't believe that it was implemented in 64K, \
then fuck up and watch the DOS version!\
\n\n\
It was not a hard work to port the program to win32, however we changed \
the compiler from Watcom C++/TASM to Visual C++, the soundsystem from \
MXMPlay to MIDAS, the video environment from VBE to DirectDraw. We hope \
intro coders will follow this method, because non-GUS-owners propably \
never watch an intro without music. And there are some lame guys \
finding VBE configuration too difficult, hehehe.\
\n\n\
Zooley had remixed the original music. Xtro / Rhyme did not do anything, \
because his logo was simply perfect.\n\
The win32 code is a bit messy (and untested on NT), so it may contain bugs, \
but I don't care. I had no more time for this project, I'll have to start \
new ones. To tell you the truth, I was very-very tired coding this. And I \
also had a terrible hangover. Sorry. \
\n\n\
Aron / Contract\t (gombasa@almos.vein.hu) \n\
\n\
You should read also the original infofile named \"elifofni\"!","Contract : (Independent) Love Bong",MB_ICONINFORMATION | MB_OK);
					break;
				}

				case IDC_EXIT:
				{
					EndDialog(hDlg,1);
					break;
				}
			}
			return TRUE;
		}
	}

	return FALSE;
}

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
    switch(msg)
    {
		case WM_ACTIVATEAPP:
			// aktivalas/deaktivalas jelzese:
			bActive= wParam;  
			break;        
	
		case WM_CREATE:
			// programpeldany handle elmentese:
			hInstance= ((LPCREATESTRUCT)lParam)->hInstance;
			break;

		case WM_DESTROY:
			// kilepes a programbol:
			PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					// alrendszerek bezarasa:
					bDDrawInitialized= FALSE;
					CloseVideoSystem();
					CloseAudioSystem(hWnd);

					// elkoszono ablak:
					SetWindowPos(hWnd,0,(GetSystemMetrics(SM_CXFULLSCREEN) - 512 - 6)/2,(GetSystemMetrics(SM_CYFULLSCREEN) - 384 - 24)/2,512 + 6,384 + 24,0);
					MessageBox(hWnd,"Thanks to everyone who helped us.\n\nAnd never forget the following very clever remark: \n\"They got the same shit over there, but there are little differences.\"\n\nCopyright  1999 Contract, Inc.","Contract : (Independent) Love Bong",MB_OK);

					// kilepes:
					PostMessage(hWnd,WM_DESTROY,0,0);
					break;

				case VK_MENU:
					// FPS meter:
					break;
			}
			break;

		case WM_SETCURSOR:
			// videomodvaltaskor kikapcsoljuk a kurzort:
			if(bHideCursor == TRUE) SetCursor(NULL);
			break;

		case WM_STARTINTRO:
			// intro inicializalasa:
			InitIntro();
			InitAudioSystem(hWnd);

			// Setup dialogusablak megjelenitese:
			if(DialogBox(hInstance,MAKEINTRESOURCE(IDD_DIALOGSETUP),hWnd,(DLGPROC)SetupDlgProc) == 1) 
			{
				PostMessage(hWnd,WM_CLOSE,0,0);
				break;
			}

			// alrendszerek inicializasa:
			StartMusic(hWnd,MUSIC_STARTPOSITION);
			bHideCursor= TRUE;
			InitVideoSystem(hWnd,320,200,dwBitDepthSelected);

			// timer kezdoertek elmentese:
			dwTimeStart= timeGetTime();
			
			// minden rendben volt:
			bDDrawInitialized= TRUE;
			break;
		
		default:
			return(DefWindowProc(hWnd,msg,wParam,lParam));
   }

   return 0;
}

int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{    	
	WNDCLASS wc_main;
    MSG msg;

    // ablakosztaly regisztralasa:
    if(!hPrevInstance)
    {
		wc_main.lpszClassName= "IntroAppClass";
        wc_main.lpfnWndProc= MainWndProc;
        wc_main.style= CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
        wc_main.hInstance= hInstance;
        wc_main.hIcon= 0;
        wc_main.hCursor= LoadCursor(NULL,IDC_ARROW);
        wc_main.hbrBackground= CreatePatternBrush(LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_SPLASHBMP)));
        wc_main.lpszMenuName= 0;
        wc_main.cbClsExtra= 0;
        wc_main.cbWndExtra= 0;
        RegisterClass(&wc_main);
    }

    // ablak krealasa es megjelenitese:
    hMainWindow = CreateWindowEx(WS_EX_STATICEDGE,"IntroAppClass","Contract : (Independent) Love Bong",WS_CAPTION,
								 (GetSystemMetrics(SM_CXFULLSCREEN) - 512 - 6)/2,(GetSystemMetrics(SM_CYFULLSCREEN) - 384 - 24)/2,512 + 6,384 + 24,
								 NULL,NULL,hInstance,NULL);
    ShowWindow(hMainWindow,nCmdShow);
	PostMessage(hMainWindow,WM_STARTINTRO,0,0);

    // uzenettovabbito ciklus:
	while(TRUE)
	{
		if(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{		
			if(msg.message == WM_QUIT) break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);

		}

		PollTimer();
		if(PerformIntro() == FALSE) PostMessage(hMainWindow,WM_KEYDOWN,VK_ESCAPE,0);
 	}

    return msg.wParam;
}
